!Object constantsFor: 'Geos Libraries'!

geosLIB27 'SYSTEM\game'! !

!Object constantsFor: 'Geos vardata'!

attrHighScoreShowScoresTriggerMoniker 27648!
attrHighScoreNameTitleMoniker 27652!
attrHighScoreDateTitleMoniker 27656!
attrHighScoreScoreTitleMoniker 27660!
attrHighScoreExtraTitleMoniker 27664!
!

!Object constantsFor: 'Geos messages'!

contentStartGame 19456!
contentPauseGame 19457!
contentContinueGame 19458!
contentAbortGame 19459!
contentGameOver 19460!
contentTimerTick 19461!
contentTempPause 19462!
contentEndTempPause 19463!
scoreAddScore 27648!
scoreGetName 27649!
scoreShowScores 27650!
scoreFormatScore 27651!
!

!Geos class methodsFor: 'library calls'!

GameRandom: maxValue
	"word pascal GameRandom(word maxValue) in game.goh"
	^GEOS call: maxValue with: #[27 0 4 1 1]!

!

VisContent subclass: #GameContent
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #GameStatusControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #HighScore
	instanceVariableNames: ''
	classVariableNames: ''!

!GameContent comment!
Library game, file game.goh! !

!GameContent class methodsFor: 'library linkage'!

library
	^27!

entry
	^0!
!

!GameContent methodsFor: 'Geos instance variables'!

gciStatus
	"@instance GameStatus GCI_status"
	^self byteAt: 115!

gciStatus: value
	"@instance GameStatus GCI_status"
	^self byteAt: 115 put: value!

gciGstate
	"@instance MemHandle GCI_gstate"
	^self wordAt: 116!

gciGstate: value
	"@instance MemHandle GCI_gstate"
	^self wordAt: 116 put: value!

gciTimerHandle
	"@instance TimerHandle GCI_timerHandle"
	^self wordAt: 118!

gciTimerHandle: value
	"@instance TimerHandle GCI_timerHandle"
	^self wordAt: 118 put: value!

gciTimerID
	"@instance word GCI_timerID"
	^self wordAt: 120!

gciTimerID: value
	"@instance word GCI_timerID"
	^self wordAt: 120 put: value!

gciTimerInterval
	"@instance word GCI_timerInterval"
	^self wordAt: 122!

gciTimerInterval: value
	"@instance word GCI_timerInterval"
	^self wordAt: 122 put: value!

gciBaseWidth
	"@instance word GCI_baseWidth"
	^self wordAt: 124!

gciBaseWidth: value
	"@instance word GCI_baseWidth"
	^self wordAt: 124 put: value!

gciBaseHeight
	"@instance word GCI_baseHeight"
	^self wordAt: 126!

gciBaseHeight: value
	"@instance word GCI_baseHeight"
	^self wordAt: 126 put: value!

!

!GameContent methodsFor: 'Geos vardata'!

!

!GameContent methodsFor: 'Geos messages'!

contentStartGame
	"@message void MSG_GAME_CONTENT_START_GAME()"
	^self geosMessage: #[76 0 2 0 0]!

contentPauseGame
	"@message void MSG_GAME_CONTENT_PAUSE_GAME()"
	^self geosMessage: #[76 1 2 0 0]!

contentContinueGame
	"@message void MSG_GAME_CONTENT_CONTINUE_GAME()"
	^self geosMessage: #[76 2 2 0 0]!

contentAbortGame
	"@message void MSG_GAME_CONTENT_ABORT_GAME()"
	^self geosMessage: #[76 3 2 0 0]!

contentGameOver
	"@message void MSG_GAME_CONTENT_GAME_OVER()"
	^self geosMessage: #[76 4 2 0 0]!

contentTimerTick
	"@message void MSG_GAME_CONTENT_TIMER_TICK()"
	^self geosMessage: #[76 5 2 0 0]!

contentTempPause
	"@message void MSG_GAME_CONTENT_TEMP_PAUSE()"
	^self geosMessage: #[76 6 2 0 0]!

contentEndTempPause
	"@message void MSG_GAME_CONTENT_END_TEMP_PAUSE()"
	^self geosMessage: #[76 7 2 0 0]!

!

!GameStatusControl comment!
Library game, file game.goh! !

!GameStatusControl class methodsFor: 'library linkage'!

library
	^27!

entry
	^1!
!

!GameStatusControl methodsFor: 'Geos instance variables'!

!

!GameStatusControl methodsFor: 'Geos vardata'!

!

!GameStatusControl methodsFor: 'Geos messages'!

!

!HighScore comment!
Library game, file game.goh! !

!HighScore class methodsFor: 'library linkage'!

library
	^27!

entry
	^2!
!

!HighScore methodsFor: 'Geos instance variables'!

hsiFileName
	"@instance ChunkHandle HSI_fileName"
	^self wordAt: 25!

hsiFileName: value
	"@instance ChunkHandle HSI_fileName"
	^self wordAt: 25 put: value!

hsiFileHandle
	"@instance FileHandle HSI_fileHandle"
	^self wordAt: 27!

hsiFileHandle: value
	"@instance FileHandle HSI_fileHandle"
	^self wordAt: 27 put: value!

hsiCreator
	"@instance GeodeToken HSI_creator"
	^GCSGeodeToken forPointer: (self ptrAt: 29).!

hsiCreator: aBlock
	"@instance GeodeToken HSI_creator"
	aBlock value: (GCSGeodeToken forPointer: (self ptrAt: 29)).!

hsiHighScoreTitle
	"@instance @visMoniker HSI_highScoreTitle"
	^self wordAt: 35!

hsiHighScoreTitle: value
	"@instance @visMoniker HSI_highScoreTitle"
	^self wordAt: 35 put: value!

hsiHighScoreLine1
	"@instance @visMoniker HSI_highScoreLine1"
	^self wordAt: 37!

hsiHighScoreLine1: value
	"@instance @visMoniker HSI_highScoreLine1"
	^self wordAt: 37 put: value!

hsiHighScoreLine2
	"@instance @visMoniker HSI_highScoreLine2"
	^self wordAt: 39!

hsiHighScoreLine2: value
	"@instance @visMoniker HSI_highScoreLine2"
	^self wordAt: 39 put: value!

hsiHighScoreLine3
	"@instance @visMoniker HSI_highScoreLine3"
	^self wordAt: 41!

hsiHighScoreLine3: value
	"@instance @visMoniker HSI_highScoreLine3"
	^self wordAt: 41 put: value!

hsiHighScoreLine4
	"@instance @visMoniker HSI_highScoreLine4"
	^self wordAt: 43!

hsiHighScoreLine4: value
	"@instance @visMoniker HSI_highScoreLine4"
	^self wordAt: 43 put: value!

hsiScoreType
	"@instance ScoreType HSI_scoreType"
	^self byteAt: 45!

hsiScoreType: value
	"@instance ScoreType HSI_scoreType"
	^self byteAt: 45 put: value!

hsiAttrs
	"@instance HighScoreAttributes HSI_attrs"
	^self byteAt: 46!

hsiAttrs: value
	"@instance HighScoreAttributes HSI_attrs"
	^self byteAt: 46 put: value!

!

!HighScore methodsFor: 'Geos vardata'!

attrHighScoreShowScoresTriggerMoniker: value
	"@vardata ChunkHandle ATTR_HIGH_SCORE_SHOW_SCORES_TRIGGER_MONIKER"
	^self addVardata: ##attrHighScoreShowScoresTriggerMoniker word: value!

attrHighScoreNameTitleMoniker: value
	"@vardata ChunkHandle ATTR_HIGH_SCORE_NAME_TITLE_MONIKER"
	^self addVardata: ##attrHighScoreNameTitleMoniker word: value!

attrHighScoreDateTitleMoniker: value
	"@vardata ChunkHandle ATTR_HIGH_SCORE_DATE_TITLE_MONIKER"
	^self addVardata: ##attrHighScoreDateTitleMoniker word: value!

attrHighScoreScoreTitleMoniker: value
	"@vardata ChunkHandle ATTR_HIGH_SCORE_SCORE_TITLE_MONIKER"
	^self addVardata: ##attrHighScoreScoreTitleMoniker word: value!

attrHighScoreExtraTitleMoniker: value
	"@vardata ChunkHandle ATTR_HIGH_SCORE_EXTRA_TITLE_MONIKER"
	^self addVardata: ##attrHighScoreExtraTitleMoniker word: value!

!

!HighScore methodsFor: 'Geos messages'!

scoreAddScore: score with: extra
	"@message Boolean MSG_HIGH_SCORE_ADD_SCORE(dword score = dx:cx, MemHandle extra = bp)= carry"
	^self geosMessage: #[108 0 3 238 2 1 4] with: score with: extra!

scoreGetName: buffer
	"@message word MSG_HIGH_SCORE_GET_NAME(char *buffer = dx:bp)= cx"
	^self geosMessage: #[108 1 102 62 3 1] with: buffer!

scoreShowScores: scoreToHighlight
	"@message void MSG_HIGH_SCORE_SHOW_SCORES(word scoreToHighlight = cx)"
	^self geosMessage: #[108 2 2 5 1 0] with: scoreToHighlight!

scoreFormatScore: dest with: score
	"@message void MSG_HIGH_SCORE_FORMAT_SCORE(@stack char *dest, dword score)"
	^self geosMessage: #[108 3 0 8 3 2 0] with: dest with: score!

!

